﻿USE [%ИмяБД%]

CREATE TABLE [Transactions](
	[id] [bigint] IDENTITY(1,1) NOT NULL,
	[posnumber] [numeric](5, 0) NOT NULL,
	[code] [bigint] NOT NULL,
	[transactiondate] [datetime] NULL,
	[transactiontype] [numeric](4, 0) NULL,
	[chequenumber] [numeric](12, 0) NULL,
	[section] [numeric](4, 0) NULL,
	[cashiercode] [numeric](5, 0) NULL,
	[goodcode] [nvarchar](150) NULL,
	[price] [numeric](17, 2) NULL,
	[amount] [numeric](17, 3) NULL,
	[sum] [numeric](17, 2) NULL,
	[additionaldata] [nvarchar](max) NULL,
 CONSTRAINT [PK_id] UNIQUE CLUSTERED 
(
	[id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

CREATE NONCLUSTERED INDEX [index_check_number_Transactions] ON [Transactions]
(
	[chequenumber] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]

CREATE NONCLUSTERED INDEX [index_pos_code_Transactions] ON [Transactions]
(
	[posnumber] ASC,
	[code] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]

CREATE TABLE [groups](
	[groupid] [bigint] NOT NULL,
	[groupname] [nvarchar](150) NULL,
 CONSTRAINT [PK_groups] PRIMARY KEY CLUSTERED 
(
	[groupid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

CREATE TABLE [groupsrelations](
	[groupid] [bigint] NOT NULL,
	[posnumber] [numeric](5, 0) NOT NULL,
 CONSTRAINT [PK_groupsrelations] PRIMARY KEY CLUSTERED 
(
	[posnumber] ASC,
	[groupid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

ALTER TABLE [groupsrelations]  WITH CHECK ADD  CONSTRAINT [FK_groupsrelations_groups] FOREIGN KEY([groupid])
REFERENCES [groups] ([groupid])
ON UPDATE CASCADE
ON DELETE CASCADE

ALTER TABLE [groupsrelations] CHECK CONSTRAINT [FK_groupsrelations_groups]

CREATE TABLE [operationaccess](
	[posnumber] [numeric](5, 0) NOT NULL,
	[operationid] [numeric](3, 0) NOT NULL,
	[groupid] [bigint] NOT NULL,
 CONSTRAINT [PK_operationaccess] PRIMARY KEY CLUSTERED 
(
	[posnumber] ASC,
	[operationid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

ALTER TABLE [operationaccess]  WITH CHECK ADD  CONSTRAINT [FK_operationaccess_groups] FOREIGN KEY([groupid])
REFERENCES [groups] ([groupid])
ON UPDATE CASCADE
ON DELETE CASCADE

ALTER TABLE [operationaccess] CHECK CONSTRAINT [FK_operationaccess_groups]

CREATE TABLE [settings](
	[posnumber] [numeric](5, 0) NOT NULL,
	[settingname] [nvarchar](100) NOT NULL,
	[settingvalue] [nvarchar](150) NULL,
 CONSTRAINT [PK_settings] PRIMARY KEY CLUSTERED 
(
	[posnumber] ASC,
	[settingname] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

CREATE TABLE [receipts](
	[receiptid] [bigint] IDENTITY(1,1) NOT NULL,
	[posnumber] [numeric](5, 0) NOT NULL,
	[startcode] [numeric](19, 0) NOT NULL,
	[endcode] [numeric](19, 0) NOT NULL,
	[referenceid] [bigint] NULL,
	[chequenumber] [numeric](12, 0) NOT NULL,
	[chequedate] [datetime] NOT NULL,
 CONSTRAINT [PK_receipts] PRIMARY KEY CLUSTERED 
(
	[receiptid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

CREATE NONCLUSTERED INDEX [chequenumber_receipts] ON [receipts]
(
	[chequenumber] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]

CREATE NONCLUSTERED INDEX [referenceid_receipts] ON [receipts]
(
	[referenceid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]

CREATE TABLE [receiptsdata](
	[dataid] [bigint] IDENTITY(1,1) NOT NULL,
	[receiptid] [bigint] NOT NULL,
	[dataname] [nvarchar](100) NOT NULL,
	[datavalue] [nvarchar](150) NULL,
 CONSTRAINT [PK_receiptsdata] PRIMARY KEY CLUSTERED 
(
	[dataid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

ALTER TABLE [dbo].[receiptsdata]  WITH NOCHECK ADD  CONSTRAINT [FK_receiptsdata_receipts] FOREIGN KEY([receiptid])
REFERENCES [dbo].[receipts] ([receiptid])
ON UPDATE CASCADE
ON DELETE CASCADE

ALTER TABLE [dbo].[receiptsdata] CHECK CONSTRAINT [FK_receiptsdata_receipts]

CREATE NONCLUSTERED INDEX [datanameAndValue_receiptsdata] ON [receiptsdata]
(
	[dataname] ASC,
	[datavalue] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]

