﻿CREATE TABLE dbo.transactions
(
    transactionid bigint NOT NULL GENERATED ALWAYS AS IDENTITY ( INCREMENT 1 START 1 MINVALUE 1 MAXVALUE 9223372036854775807 CACHE 1 ),
    posnumber numeric(5,0) NOT NULL,
    code numeric(19,0) NOT NULL,
    transactiondate timestamp without time zone,
    transactiontype numeric(4,0),
    chequenumber numeric(12,0),
    section numeric(4,0),
    cashiercode numeric(5,0),
    goodcode character varying(150),
    price numeric(17,2),
    amount numeric(17,3),
    sum numeric(17,2),
    additionaldata text,
    CONSTRAINT transactions_pkey PRIMARY KEY (posnumber, code),
    CONSTRAINT transactions_id_unique UNIQUE (transactionid)

);

CREATE INDEX transactions_index_checknumber
    ON dbo.transactions USING btree
    (chequenumber);

CREATE INDEX "transactions_index_posnumberAndCode"
    ON dbo.transactions USING btree
    (posnumber, code);
    
CREATE TABLE dbo.groups
(
    groupid bigint NOT NULL,
    groupname character varying(150) COLLATE pg_catalog."default" NOT NULL,
    CONSTRAINT groups_pkey PRIMARY KEY (groupid)
);

CREATE INDEX groups_index_pkey
    ON dbo.groups USING btree
    (groupid);

ALTER TABLE dbo.groups
    CLUSTER ON groups_index_pkey;

CREATE TABLE dbo.groupsrelations
(
    groupid bigint NOT NULL,
    posnumber numeric(5,0) NOT NULL,
    CONSTRAINT groupsrelations_pkey PRIMARY KEY (posnumber, groupid),
    CONSTRAINT groupsrelations_groupid_fkey FOREIGN KEY (groupid)
        REFERENCES dbo.groups (groupid) MATCH SIMPLE
        ON UPDATE CASCADE
        ON DELETE CASCADE
);

CREATE INDEX grouprelations_index_pkey
    ON dbo.groupsrelations USING btree
    (groupid, posnumber);

ALTER TABLE dbo.groupsrelations
    CLUSTER ON grouprelations_index_pkey;
    
CREATE TABLE dbo.operationaccess
(
    posnumber numeric(5,0) NOT NULL,
    operationid numeric(3,0) NOT NULL,
    groupid bigint NOT NULL,
    CONSTRAINT operationaccess_pkey PRIMARY KEY (posnumber, operationid),
    CONSTRAINT operationaccess_groupid_fkey FOREIGN KEY (groupid)
        REFERENCES dbo.groups (groupid) MATCH SIMPLE
        ON UPDATE CASCADE
        ON DELETE CASCADE
);

CREATE INDEX operationaccess_index_pkey
    ON dbo.operationaccess USING btree
    (posnumber, operationid);

ALTER TABLE dbo.operationaccess
    CLUSTER ON operationaccess_index_pkey;

CREATE TABLE dbo.settings
(
    posnumber numeric(5,0) NOT NULL,
    settingname character varying(100) COLLATE pg_catalog."default" NOT NULL,
    settingvalue character varying(150) COLLATE pg_catalog."default",
    CONSTRAINT settings_pkey PRIMARY KEY (posnumber, settingname)
);

CREATE INDEX settings_index_pkey
    ON dbo.settings USING btree
    (posnumber, settingname COLLATE pg_catalog."default");

ALTER TABLE dbo.settings
    CLUSTER ON settings_index_pkey;
 
CREATE TABLE dbo.receipts
(
    receiptid bigint NOT NULL GENERATED ALWAYS AS IDENTITY ( INCREMENT 1 START 1 MINVALUE 1 MAXVALUE 9223372036854775807 CACHE 1 ),
    posnumber numeric(5,0) NOT NULL,
    startcode numeric(19,0) NOT NULL,
    endcode numeric(19,0) NOT NULL,
    referenceid bigint,
    chequenumber numeric(12,0) NOT NULL,
    chequedate timestamp without time zone NOT NULL,
    CONSTRAINT receipts_pkey PRIMARY KEY (receiptid)
);

CREATE INDEX receipts_index_chequenumber
    ON dbo.receipts USING btree
    (chequenumber);

CREATE INDEX receipts_index_pkey
    ON dbo.receipts USING btree
    (receiptid);

ALTER TABLE dbo.receipts
    CLUSTER ON receipts_index_pkey;

CREATE INDEX receipts_index_referenceid
    ON dbo.receipts USING btree
    (referenceid);

CREATE TABLE dbo.receiptsdata
(
    dataid bigint NOT NULL GENERATED ALWAYS AS IDENTITY ( INCREMENT 1 START 1 MINVALUE 1 MAXVALUE 9223372036854775807 CACHE 1 ),
    receiptid bigint NOT NULL,
    dataname character varying(100) COLLATE pg_catalog."default" NOT NULL,
    datavalue character varying(150) COLLATE pg_catalog."default",
    CONSTRAINT receiptsdata_pkey PRIMARY KEY (dataid),
    CONSTRAINT receiptsdata_receiptid_fkey FOREIGN KEY (receiptid)
        REFERENCES dbo.receipts (receiptid) MATCH SIMPLE
        ON UPDATE CASCADE
        ON DELETE CASCADE
);   

CREATE INDEX "receiptsdata_index_datanameAndValue"
    ON dbo.receiptsdata USING btree
    (dataname COLLATE pg_catalog."default", datavalue COLLATE pg_catalog."default");

CREATE INDEX receiptsdata_index_pkey
    ON dbo.receiptsdata USING btree
    (dataid);
    
ALTER TABLE dbo.receiptsdata
    CLUSTER ON receiptsdata_index_pkey;